PXCAXAM ;ISL/dee - Validates & Translates data from the PCE Device Interface into PCE's PXK format for Exams ;3/14/97
 ;;1.0;PCE PATIENT CARE ENCOUNTER;**27**;Aug 12, 1996
 Q
 ; Variables
 ;   PXCAXAM  Copy of a EXAM node of the PXCA array
 ;   PXCAPRV   Pointer to the provider (200)
 ;   PXCANUMB  Count of the number if XAMs
 ;   PXCAINDX  Count of the number of EXAM for one provider
 ;   PXCAFTER  Temp used to build ^TMP(PXCAGLB,$J,"XAM",PXCANUMB,0,"AFTER")
 ;   PXCAPNAR  Pointer to the provider narrative (9999999.27)
 ;
XAM(PXCAXAM,PXCANUMB,PXCAPRV,PXCAERRS) ;
 N PXCAFTER
 S PXCAFTER=$P(PXCAXAM,"^",1)_"^"_PXCAPAT_"^"_PXCAVSIT_"^"
 S PXCAFTER=PXCAFTER_$P(PXCAXAM,"^",2)
 S ^TMP(PXCAGLB,$J,"XAM",PXCANUMB,"IEN")=""
 S ^TMP(PXCAGLB,$J,"XAM",PXCANUMB,0,"BEFORE")=""
 S ^TMP(PXCAGLB,$J,"XAM",PXCANUMB,0,"AFTER")=PXCAFTER
 S ^TMP(PXCAGLB,$J,"XAM",PXCANUMB,12,"BEFORE")=""
 S ^TMP(PXCAGLB,$J,"XAM",PXCANUMB,12,"AFTER")="^^^"_$S(PXCAPRV>0:PXCAPRV,1:"")
 S ^TMP(PXCAGLB,$J,"XAM",PXCANUMB,812,"BEFORE")=""
 S ^TMP(PXCAGLB,$J,"XAM",PXCANUMB,812,"AFTER")="^"_PXCAPKG_"^"_PXCASOR
 Q
 ;
EXAM(PXCA,PXCABULD,PXCAERRS) ;Validation routine for XAM
 Q:'$D(PXCA("EXAM"))
 N PXCAXAM,PXCAPRV,PXCANUMB,PXCAINDX
 N PXCAITEM
 S PXCAPRV=""
 S PXCANUMB=0
 F  S PXCAPRV=$O(PXCA("EXAM",PXCAPRV)) Q:PXCAPRV']""  D
 . I PXCAPRV>0 D
 .. I '$$ACTIVPRV^PXAPI(PXCAPRV,PXCADT) S PXCA("ERROR","EXAM",PXCAPRV,0,0)="Provider is not active or valid^"_PXCAPRV
 .. E  I PXCABULD!PXCAERRS D ANOTHPRV^PXCAPRV(PXCAPRV)
 . S PXCAINDX=0
 . F  S PXCAINDX=$O(PXCA("EXAM",PXCAPRV,PXCAINDX)) Q:PXCAINDX']""  D
 .. S PXCAXAM=$G(PXCA("EXAM",PXCAPRV,PXCAINDX))
 .. S PXCANUMB=PXCANUMB+1
 .. I PXCAXAM="" S PXCA("ERROR","EXAM",PXCAPRV,PXCAINDX,0)="EXAM data missing" Q
 .. S PXCAITEM=+$P(PXCAXAM,U,1)
 .. I $G(^AUTTEXAM(PXCAITEM,0))="" S PXCA("ERROR","EXAM",PXCAPRV,PXCAINDX,1)="EXAM type not in file 9999999.15^"_PXCAITEM
 .. S PXCAITEM=$P(PXCAXAM,U,2) I '(PXCAITEM=""!(PXCAITEM="A")!(PXCAITEM="N")) S PXCA("ERROR","EXAM",PXCAPRV,PXCAINDX,2)="EXAM results must be A|N^"_PXCAITEM
 .. I PXCABULD&'$D(PXCA("ERROR","EXAM",PXCAPRV,PXCAINDX))!PXCAERRS D XAM(PXCAXAM,.PXCANUMB,PXCAPRV,PXCAERRS)
 Q
 ;
